-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.qDoneFort = false
    self.qDoneHilltop = false
    self.p0 = Citadels.GetPlayer(0)
    self.townDestroyed:LinkToTarget("deactHandler")
    
    if not self.loaded then
      self.qDoneSmallTown = 0
			self.allQuests = 0
    end
  end
  
  if self.qDoneSmallTown == 3 then
    self.p0:WinQuest('D07_SMALL_TOWN')
    self.p0:AddResource(6, 40)
    self.p0:AddResource(8, 200)
    self.townDestroyed:TriggerAllTargets()
		self.allQuests = self.allQuests + 1
    self.qDoneSmallTown = 0
  end
  
  if self.qDoneHilltop then
    self.p0:WinQuest('D07_FORWARD_BASE')
    self.p0:WinQuest('D07_FORT')
    self.p0:AddResource(7, 20)
		self.allQuests = self.allQuests + 1
    self.qDoneHilltop = false
  end
	
	if self.allQuests == 2 then
		self.p0:UnlockCharacter("D_King-Guthrum")
		self.allQuests = 0
	end	
end

function OnTrigger(self, source, target)
  if target == "questSmallTown" then
    self.qDoneSmallTown = self.qDoneSmallTown + 1
  elseif target == "questHilltop" then
    self.qDoneHilltop = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.qDoneSmallTown = ar:Read()
		self.allQuests = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.qDoneSmallTown)
		ar:Write(self.allQuests)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("questSmallTown")
  self:AddTriggerTarget("questFort")
  self:AddTriggerTarget("questHilltop")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("townDestroyed")
end
